---------------
-- Accuracy Gym
---------------

local LittleMatt = setmetatable({},NPC):new( 9, 3, "LittleMatt 4x4.png", "Down" )

LittleMatt.Action = function()

	if SRT.Defeated.LittleMatt then
		SRT.Dialog.Words = {{text=THEME:GetString("AccuracyGym", "7")}}
	else
		SRT.Dialog.Words = {
			{ text=THEME:GetString("AccuracyGym", "1") },
			{ text=THEME:GetString("AccuracyGym", "2") },
			{ text=THEME:GetString("AccuracyGym", "3") },
			{ text=THEME:GetString("AccuracyGym", "4") },
			{ text=THEME:GetString("AccuracyGym", "5") },
			{ text=THEME:GetString("AccuracyGym", "6") },
			{
				text=function()
					TransitionToBattle(1)
					return ""
				end
			}
		}
	end

	StartDialog("#4898e8", "Little Matt")
end

return {

	--exit map via bottom
	{
		Tile = { r=9, d=11 },
		Trigger = "PlayerTouch",
		Action = function()
			SRT.Transition.NextMap="Hometown"
			SRT.Transition.NextPos={ r=25, d=6, z=-1 }
			SRT.MapFade:queuecommand("FadeOut")
		end

	},

	-- EndGame
	{
		Tile = { r=9, d=9 },
		Trigger = "PlayerTouch",
		Action = function()
			if IsEndGame() then
				SRT.Dialog.Words = {{text="HEEEEEEEELP!!!\n" .. SRT.Player.Name .. ", come to the Pokémon Center quickly!"}}
				StartDialog("#666666", "Sami")
			end
		end
	},

	LittleMatt,

	-- blue torches
	setmetatable({}, AnimatedSprite):new(8, 11, "bluetorch", 0.1),
	setmetatable({}, AnimatedSprite):new(8, 10, "bluetorch", 0.15),
	setmetatable({}, AnimatedSprite):new(8, 9, "bluetorch", 0.2),
	setmetatable({}, AnimatedSprite):new(8, 8, "bluetorch", 0.1),
	setmetatable({}, AnimatedSprite):new(8, 7, "bluetorch", 0.125),
	setmetatable({}, AnimatedSprite):new(8, 6, "bluetorch", 0.12),
	setmetatable({}, AnimatedSprite):new(7, 5, "bluetorch", 0.1),
	setmetatable({}, AnimatedSprite):new(7, 4, "bluetorch", 0.133),
	setmetatable({}, AnimatedSprite):new(7, 3, "bluetorch", 0.2),
	setmetatable({}, AnimatedSprite):new(10, 11, "bluetorch", 0.15),
	setmetatable({}, AnimatedSprite):new(10, 10, "bluetorch", 0.125),
	setmetatable({}, AnimatedSprite):new(10, 9, "bluetorch", 0.133),
	setmetatable({}, AnimatedSprite):new(10, 8, "bluetorch", 0.135),
	setmetatable({}, AnimatedSprite):new(10, 7, "bluetorch", 0.2),
	setmetatable({}, AnimatedSprite):new(10, 6, "bluetorch", 0.125),
	setmetatable({}, AnimatedSprite):new(11, 5, "bluetorch", 0.1),
	setmetatable({}, AnimatedSprite):new(11, 4, "bluetorch", 0.135),
	setmetatable({}, AnimatedSprite):new(11, 3, "bluetorch", 0.15),
}